/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.watch;

import io.gitlab.jfronny.commons.throwable.ThrowingRunnable;
import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.config.api.v2.ConfigHolder;
import io.gitlab.jfronny.libjf.config.impl.watch.JfConfigWatchService;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;

public class JfConfigWatchServiceImpl
implements JfConfigWatchService {
    private static final Path CONFIG_DIR = FabricLoader.getInstance().getConfigDir();
    private static final Set<JfConfigWatchServiceImpl> REGISTERED_INSTANCES = new HashSet<JfConfigWatchServiceImpl>();
    private final WatchService service;
    private static final Map<Path, Integer> locked = new HashMap<Path, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <TEx extends Throwable> void lock(Path p, ThrowingRunnable<TEx> task) throws TEx {
        Path path = CONFIG_DIR;
        synchronized (path) {
            locked.compute(p, (p1, val) -> val == null ? 1 : val + 1);
            task.run();
            for (JfConfigWatchServiceImpl instance : REGISTERED_INSTANCES) {
                instance.executeIteration();
            }
        }
    }

    public JfConfigWatchServiceImpl() {
        WatchService ws = null;
        try {
            ws = FileSystems.getDefault().newWatchService();
            CONFIG_DIR.register(ws, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
        }
        catch (IOException e) {
            if (ws != null) {
                try {
                    ws.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ws = null;
            }
            LibJf.LOGGER.error("Could not initialize FS watcher for configs", new Object[0]);
        }
        this.service = ws;
        REGISTERED_INSTANCES.add(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeIteration() {
        Path path = CONFIG_DIR;
        synchronized (path) {
            WatchKey key = this.service.poll();
            if (key != null) {
                ConfigHolder ch = ConfigHolder.getInstance();
                for (WatchEvent<?> event : key.pollEvents()) {
                    Object obj = event.context();
                    if (!(obj instanceof Path)) continue;
                    Path p = (Path)obj;
                    if (!ch.isRegistered(p = CONFIG_DIR.resolve(p))) continue;
                    int lockCurr = locked.getOrDefault(p, 0);
                    if (lockCurr == 0) {
                        LibJf.LOGGER.info("Detected updated config: " + String.valueOf(p) + ", reloading", new Object[0]);
                        ch.get(p).load();
                        continue;
                    }
                    locked.put(p, lockCurr - 1);
                }
                if (!key.reset()) {
                    LibJf.LOGGER.error("Could not reset config watch key", new Object[0]);
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.service.close();
        REGISTERED_INSTANCES.remove(this);
    }
}

